//
//  OPImageProcess.h
//  ApplicationFrameworks
//
//  Created by Nathan Van Fleet on 2015-08-28.
//
//

#import <Foundation/Foundation.h>

#import "OnePasswordCoreConstants.h"

@interface OPImageProcess : NSObject

+ (OPImage *)processedCircularImage:(OPImage *)image borderWidth:(CGFloat)width borderColor:(OPColor *)borderColor size:(CGFloat)size;

+ (OPImage *)processImage:(OPImage *)baseImage withOverlayedImageInRightBottom:(OPImage *)overlayedImage ofSize:(CGFloat)size;

+ (OPImage *)processedCroppedResizedSquareImage:(OPImage *)image size:(CGFloat)iconSize;

#pragma mark - Image Encoding

+ (NSData *)encodedImage:(OPImage *)image maxDataSize:(NSUInteger)maxDataSize;

+ (NSData *)pngWithDefaultEncodingOfImage:(OPImage *)inputImage;

@end
